<?php
/**
 * @package     extension.administrator
 * @subpackage  com_gpstools
 *
 * @copyright   Copyright (C) 2009 - 2025 BulaSikku Technologies Pvt. Ltd. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined( '_JEXEC' ) or die();

HTMLHelper::addIncludePath( JPATH_COMPONENT . '/helpers' );

$app    = Factory::getApplication();
$params = $this->item->params;
$layout = $params->get( 'ui_layout', 'default' );

$start    = $app->input->getInt( 'start', 0 );
$trackUri = GpsToolsHelperRoute::getTrackRoute( $this->item->slug, $this->item->catslug, $this->item->language, $start );

$document = Factory::getDocument();
$document->setMetaData( 'viewport', 'initial-scale=1.0, user-scalable=no' );

if ( $params->get( 'maps_provider', 'google' ) == 'openstreetmap' )
{
	$document->addStyleSheet( G_MEDIA_PATH_URI . 'css/leaflet.css' );
	$document->addStyleSheet( G_MEDIA_PATH_URI . 'css/styledLayerControl.css' );
	$document->addStyleSheet( G_MEDIA_PATH_URI . 'css/L.Control.Locate.min.css' );
	$document->addScript( G_MEDIA_PATH_URI . 'js/leaflet.js' );
	$document->addScript( G_MEDIA_PATH_URI . 'js/leaflet.fullscreen.min.js' );
	$document->addScript( G_MEDIA_PATH_URI . 'js/leaflet-providers.js' );
	$document->addScript( G_MEDIA_PATH_URI . 'js/styledLayerControl.js' );
	$document->addScript( G_MEDIA_PATH_URI . 'js/leaflet.geometryutil.js' );
	$document->addScript( G_MEDIA_PATH_URI . 'js/leaflet-distance-marker.js' );
	$document->addScript( G_MEDIA_PATH_URI . 'js/leaflet-easy-print.min.js' );
	$document->addScript( G_MEDIA_PATH_URI . 'js/L.Control.Locate.min.js' );
}
else
{
	?>
    <script>
      (g => {
        var h, a, k, p = 'The Google Maps JavaScript API', c = 'google', l = 'importLibrary', q = '__ib__', m = document, b = window
        b = b[c] || (b[c] = {})
        var d = b.maps || (b.maps = {}), r = new Set, e = new URLSearchParams, u = () => h || (h = new Promise(async (f, n) => {
          await (a = m.createElement('script'))
          e.set('libraries', [...r] + '')
          for (k in g) {
            e.set(k.replace(/[A-Z]/g, t => '_' + t[0].toLowerCase()), g[k])
          }
          e.set('callback', c + '.maps.' + q)
          a.src = `https://maps.${c}apis.com/maps/api/js?` + e
          d[q] = f
          a.onerror = () => h = n(Error(p + ' could not load.'))
          a.nonce = m.querySelector('script[nonce]')?.nonce || ''
          m.head.append(a)
        }))
        d[l] ? console.warn(p + ' only loads once. Ignoring:', g) : d[l] = (f, ...n) => r.add(f) && u().then(() => d[l](f, ...n))
      })({
        key: '<?php echo $params->get( 'google_api_key' );?>',
        v: 'weekly',
      })
    </script>
	<?php
}

$document->addScriptOptions( 'com_gpstools', TracksHelper::getTrackConfiguration( $params, $this->item->category->params ) );
$document->addScript( 'https://www.gstatic.com/charts/loader.js' );
$document->addScriptDeclaration( "google.charts.load('current', {'packages':['corechart', 'controls']}); google.charts.setOnLoadCallback(GpsToolsApi.init_track);" );
$document->addScript( G_JS_FILE_STORE_URI . $this->item->file_name . '.min.js' );
?>
<div id="cj-wrapper" class="track-details<?php echo $this->pageclass_sfx ?>">

	<?php
	echo CJFunctions::load_module_position( 'tracks-individual-above-toolbar' );
	echo TracksHelper::renderLayout( $layout . '.toolbar', [ 'params' => $params, 'state' => $this->state ] );

	if ( $params->get( 'show_navigation' ) && ! $params->get( 'navigation_position', 1 ) )
	{
		echo TracksHelper::renderLayout( $layout . '.track.navigation', [ 'data' => $this ] );
	}

	echo CJFunctions::load_module_position( 'tracks-individual-above-content' );
	echo TracksHelper::renderLayout( $layout . '.track.details', [ 'data' => $this ] );



	echo CJFunctions::load_module_position( 'tracks-individual-above-map' );
	// Gilles - 01/01/2026 -> Modif
	//Affiche DOWNLOAD juste avant la MAP
	echo TracksHelper::renderLayout( $layout . '.track.download', [ 'data' => $this ] );
	// Fin de Modif
	
	echo TracksHelper::renderLayout( $layout . '.track.map', [ 'data' => $this ] );

	echo CJFunctions::load_module_position( 'tracks-individual-above-charts' );
	echo TracksHelper::renderLayout( $layout . '.track.charts', [ 'data' => $this ] );

	echo CJFunctions::load_module_position( 'tracks-individual-above-track-info' );
	echo TracksHelper::renderLayout( $layout . '.track.stats', [ 'data' => $this ] );

	echo TracksHelper::renderLayout( $layout . '.track.waypoints', [ 'data' => $this ] );
	// Modif Gilles - Affiche DOWNLOAD juste avant la MAP
	// echo TracksHelper::renderLayout( $layout . '.track.download', [ 'data' => $this ] );

	if ( $params->get( 'show_navigation' ) && $params->get( 'navigation_position', 1 ) )
	{
		echo TracksHelper::renderLayout( $layout . '.track.navigation', [ 'data' => $this ] );
	}

	echo CJFunctions::load_module_position( 'tracks-individual-above-suggestions' );
	echo TracksHelper::renderLayout( $layout . '.track.suggestions', [ 'data' => $this ] );

	echo CJFunctions::load_module_position( 'tracks-individual-above-comments' );
	echo TracksHelper::renderLayout( $layout . '.track.comments', [ 'data' => $this ] );
	echo TracksHelper::renderLayout( $layout . '.track.modals', [ 'data' => $this ] );

	echo CJFunctions::load_module_position( 'tracks-individual-below-content' );
	?>

    <form name="adminForm" id="adminForm" method="post" enctype="multipart/form-data" action="<?php echo Route::_( $trackUri ); ?>">
        <input type="hidden" name="t_id" value="<?php echo $this->item->id; ?>">
        <input type="hidden" name="cid" value="">
        <input type="hidden" name="task" value="">
        <input type="hidden" name="view" value="track">
        <input type="hidden" name="return" value="<?php echo base64_encode( $trackUri ); ?>">
        <input type="hidden" name="score" value="">
        <input type="hidden" name="dfilename" value="">
        <input type="hidden" name="lat" value="">
        <input type="hidden" name="lng" value="">
		<?php echo HTMLHelper::_( 'form.token' ); ?>
    </form>

    <div style="display: none">
        <input id="gpstools_pageid" type="hidden" value="track">
    </div>
</div>